﻿using System.Collections.Generic;

namespace VeteransAffairs.Registries.BusinessManager
{
    public class PatientImageDetailManager : BaseBO
    {
        private readonly PatientImageRepository _patientImageRepository;
        private readonly PatientImageDetailRepository _patientImageDetailRepository;

        public PatientImageDetailManager()
        {
            _patientImageRepository = new PatientImageRepository();
            _patientImageDetailRepository = new PatientImageDetailRepository();
        }

        public static IEnumerable<string> LoadReferenceImageBodyParts()
        {
            return PatientImageDetailRepository.LoadReferenceImageBodyParts();
        }

        public static IEnumerable<string> LoadReferenceImageFragmentCounts()
        {
            return PatientImageDetailRepository.LoadReferenceImageFragmentCounts();
        }

        public static IEnumerable<string> LoadReferenceImageReasons()
        {
            return PatientImageDetailRepository.LoadReferenceImageReasons();
        }

        public static IEnumerable<string> LoadReferenceImageTypes()
        {
            return PatientImageDetailRepository.LoadReferenceImageTypes();
        }

        public PatientImageDetail GetPatientImageDetails(int patientImageId)
        {
            return _patientImageDetailRepository.GetPatientImageDetails(patientImageId);
        }

        public PatientImageMap[] GetImageBodyParts(int patientImageId)
        {
            return _patientImageDetailRepository.GetImageBodyParts(patientImageId);
        }

        public PatientImageMap[] GetImageReasons(int patientImageId)
        {
            return _patientImageDetailRepository.GetImageReasons(patientImageId);
        }

        public PatientImageMap GetImageType(int patientImageId)
        {
            return _patientImageDetailRepository.GetImageType(patientImageId);
        }

        public PatientImageMap GetFragmentCount(int patientImageId)
        {
            return _patientImageDetailRepository.GetFragmentCount(patientImageId);
        }

        private PatientImageMap[] GetImageMap(int patientImageId, string sproc)
        {
            return _patientImageDetailRepository.GetImageMap(patientImageId, sproc);
        }

        public int UpdatePatientImage(object[] parameters, IReadOnlyList<int> imageBodyParts, IReadOnlyList<int> imagingReasons)
        {
            var eventArgs = new BOSaveSuccessEventArgs { SaveStatusArg = SaveStatus.SaveFail };

            int result = 0;

            _patientImageDetailRepository.UpdatePatientImageTable(parameters, imageBodyParts, imagingReasons);

            eventArgs.SaveStatusArg = SaveStatus.SaveSuccess;

            RaiseSaveEvent(this, eventArgs);

            return result;
        }

    }
}
